/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.spss;

import com.bedatadriven.spss.CaseBuffer;
import com.bedatadriven.spss.CaseReader;
import com.bedatadriven.spss.MissingValuesHeader;
import com.bedatadriven.spss.SpssInputStream;
import com.bedatadriven.spss.SpssVariable;
import java.io.IOException;
import java.util.List;

class CompressedCaseReader
extends CaseReader {
    private static final int MIN_STORAGE_FLAG = 252;
    private static final int STRING_FLAG = 253;
    private static final int DOUBLE_FLAG = 253;
    private static final int WHITESPACE_FLAG = 254;
    private static final int SYSMIS_FLAG = 255;
    private static final int END_OF_BLOCK = 8;
    private int flagIndex = 8;
    private int[] flags = new int[8];

    public CompressedCaseReader(SpssInputStream inputStream, List<SpssVariable> variables, MissingValuesHeader missingValues, int numCases, CaseBuffer currentRow) {
        super(inputStream, variables, missingValues, numCases, currentRow);
    }

    @Override
    public void restart() throws IOException {
        super.restart();
        this.flagIndex = 8;
    }

    private int readNextStorageFlag() throws IOException {
        if (this.flagIndex >= 8) {
            for (int i = 0; i != 8; ++i) {
                this.flags[i] = this.inputStream.readUnsignedByte();
            }
            this.flagIndex = 0;
        }
        return this.flags[this.flagIndex++];
    }

    @Override
    protected void readRow() throws IOException {
        int storageFlag = 0;
        for (SpssVariable var : this.variables) {
            if (var.isNumeric()) {
                storageFlag = this.readNextStorageFlag();
                if (storageFlag < 252) {
                    this.currentRow.set(var.getIndex(), storageFlag - 100);
                    continue;
                }
                if (storageFlag == 253) {
                    this.currentRow.set(var.getIndex(), this.inputStream.readDouble());
                    continue;
                }
                if (storageFlag != 255) continue;
                this.currentRow.setMissing(var.getIndex());
                continue;
            }
            StringBuilder buffer = new StringBuilder();
            int totalBytesRead = 0;
            int whiteSpaceCount = 0;
            do {
                if ((storageFlag = this.readNextStorageFlag()) == 253) {
                    while (whiteSpaceCount > 0) {
                        buffer.append(' ');
                        --whiteSpaceCount;
                    }
                    buffer.append(this.inputStream.stringFromBytes(this.inputStream.readBytes(8)));
                    continue;
                }
                if (storageFlag != 254) continue;
                whiteSpaceCount += 8;
            } while ((totalBytesRead += 8) < var.stringLength);
            this.currentRow.set(var.getIndex(), buffer.toString().trim());
        }
    }
}

