/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.spss;

import com.bedatadriven.spss.SpssInputStream;
import java.io.IOException;

class FileHeader {
    private String productName;
    private int isCompressed;
    private int weightVariablePosition;
    private byte[] creationDate;
    private byte[] creationTime;
    private byte[] fileLabel;
    private int caseSize;
    private int numCases;
    private double bias;

    public FileHeader(SpssInputStream inputStream) throws IOException {
        this.productName = new String(inputStream.readBytes(60));
        this.caseSize = inputStream.readInt();
        this.isCompressed = inputStream.readInt();
        this.weightVariablePosition = inputStream.readInt();
        this.numCases = inputStream.readInt();
        this.bias = inputStream.readDouble();
        this.creationDate = inputStream.readBytes(9);
        this.creationTime = inputStream.readBytes(8);
        this.fileLabel = inputStream.readBytes(64);
        inputStream.skipBytes(3);
    }

    public int getCaseSize() {
        return this.caseSize;
    }

    public int getNumCases() {
        return this.numCases;
    }

    public int getWeightVariableRecordIndex() {
        return this.weightVariablePosition;
    }
}

