/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.spss;

import com.bedatadriven.spss.ExtendedRecordHeader;
import com.bedatadriven.spss.SpssInputStream;
import com.bedatadriven.spss.SpssVariable;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class LongVariableNamesRecord {
    static final int EXTENDED_RECORD_TYPE = 13;
    private byte[] longNames;

    LongVariableNamesRecord(ExtendedRecordHeader header, SpssInputStream inputStream) throws IOException {
        this.longNames = inputStream.readBytes(header.getTotalLength());
    }

    void parseInto(List<SpssVariable> variables, Map<String, SpssVariable> variableNames) {
        int longNamesLength = this.longNames.length;
        String shortName = null;
        byte[] longName = null;
        int tokenStart = 0;
        int varIndex = 0;
        for (int i = 0; i <= longNamesLength; ++i) {
            if (i < longNamesLength && this.longNames[i] == 61) {
                shortName = new String(this.longNames, tokenStart, i - tokenStart);
                tokenStart = i + 1;
                continue;
            }
            if (i != longNamesLength && this.longNames[i] != 9) continue;
            longName = new byte[i - tokenStart];
            System.arraycopy(this.longNames, tokenStart, longName, 0, i - tokenStart);
            if (variables.get((int)varIndex).shortName.equals(shortName)) {
                variables.get((int)varIndex).longName = longName;
            } else {
                variableNames.get((Object)shortName).longName = longName;
            }
            tokenStart = i + 1;
            ++varIndex;
        }
    }
}

