/*
 * Copyright 2020 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss

import scalatags.Text.all._
import scalatags.stylesheet._

import scala.collection.immutable

/*
 * https://github.com/tilomitra/cssextras/blob/master/css/pure-extras.css
 */
trait Extras extends CascadingStyleSheet {
  initStyleSheet()

  /* Images. */
  val pure_img_elliptical: Cls = cls(
    borderRadius:="80%",
    img(borderRadius:="50%")
  )

  val pure_img_rounded: Cls = cls(
    borderRadius:=3,
    img(borderRadius:=3)
  )

  val pure_img_bordered: Cls = cls(
    backgroundColor:="#FFFFFF",
    border:="1px solid rgba(0, 0, 0, 0.2)",
    padding:=5
  )

  /* Thumbnails */
  val pure_thumbnails: Cls = cls(
    li(
      textAlign.center,
      display.`inline-block`,
      // *display: inline;
      // *zoom: 1;
      verticalAlign.top,
      // -webkit-box-sizing: border-box;
      // -moz-box-sizing: border-box;
      boxSizing.`border-box`,
      padding:="0.5em"
    ),
    listStyle:="none",
    margin:=0,
    padding:=0,
    a.focus(outline:="0 none")
  )

  val caption_ : Cls = cls()
  val caption_head: Cls = cls()
  val pure_thumb: Cls = cls(
    display.block,
    textDecoration.none,
    color:="inherit",
    caption_(
      textAlign.left,
      display.block,
      margin:="0 5px 6px",
      p(
        margin:="0.3em 0 0",
        fontSize:="75%"
      ),
      caption_head(
        fontWeight.bold,
        marginTop:="0.3em"
      )
    ),
    img(
      maxWidth:="100%",
      marginRight.auto,
      marginLeft.auto,
      verticalAlign.middle,
      boxSizing.`border-box`
      // -webkit-box-sizing: border-box;
      // -moz-box-sizing: border-box;
    )
  )

  val pure_thumb_bordered: Cls = cls(
    border:="1px solid rgba(0, 0, 0, 0.2)"
  )

  val pure_thumb_elliptical: Cls = cls(img(borderRadius:="50%"))

  val pure_thumb_rounded: Cls = cls(img(borderRadius:=3))

  /* Badges/Pills */
  private val badge_common = immutable.Seq[StyleSheetFrag](
    padding:="0.35em 0.9em 0.35em",
    color:="#FFF",
    display.`inline-block`,
    fontSize:="11.844",
    fontWeight.bold,
    lineHeight:="1.2em",
    verticalAlign.baseline,
    whiteSpace.nowrap,
    borderRadius:=20,
    margin:="0.2em"
  )
  private val bg1: StyleSheetFrag = backgroundColor:="#9D988E"
  val pure_badge: Cls = cls(badge_common:+bg1:_*)
  private val bg2: StyleSheetFrag = backgroundColor:="#D13C38"
  val pure_badge_error: Cls = cls(badge_common:+bg2:_*)
  private val bg3: StyleSheetFrag = backgroundColor:="#E78C05"
  val pure_badge_warning: Cls = cls(badge_common:+bg3:_*)
  private val bg4: StyleSheetFrag = backgroundColor:="rgb(83, 180, 79)"
  val pure_badge_success: Cls = cls(badge_common:+bg4:_*)
  private val bg5: StyleSheetFrag = backgroundColor:="rgb(18, 169, 218)"
  val pure_badge_info: Cls = cls(badge_common:+bg5:_*)
  private val bg6: StyleSheetFrag = backgroundColor:="#4D370C"
  val pure_badge_inverse: Cls = cls(badge_common:+bg6:_*)

  /* Alerts */
  val pure_alert: Cls = cls(
    position.relative,
    marginBottom:="1em",
    padding:="1em",
    backgroundColor:="rgb(209, 235, 238)",
    borderRadius:=3,
    color:="rgb(102, 131, 145)",
    label(
      display.`inline-block`,
      // *display: inline;
      // *zoom: 1;
      whiteSpace.nowrap
    )
  )

  val pure_alert_error: Cls = cls(backgroundColor:="#D13C38", color:="#FFF")
  val pure_alert_warning: Cls = cls(
    backgroundColor:="rgb(250, 191, 103)", color:="rgb(151, 96, 13)")
  val pure_alert_success: Cls = cls(
    backgroundColor:="rgb(83, 180, 79)", color:="#FFF")

  /* Contextual Modals */
  val bottom_ : Cls = cls()
  val top_ : Cls = cls()
  val right_ : Cls = cls()
  val left_ : Cls = cls()
  private val arrow_common = immutable.Seq[StyleSheetFrag](
    borderStyle:="solid",
    borderWidth:="10px",
    height:=0,
    width:=0,
    position.absolute
  )
  val pure_arrow_border: Cls = cls(arrow_common:_*)
  val pure_arrow: Cls = cls(arrow_common:_*)
  val pure_popover: Cls = cls(
    position.relative,
    width:=300,
    backgroundColor:="#f0f1f3",
    color:="#2f3034",
    padding:=15,
    border:="1px solid #bfc0c8",
    borderRadius:=2,
    boxShadow:="0 2px 8px rgba(0, 0, 0, 0.15)",
    boxSizing.`border-box`,
    // box-padding: border-box;
    // -webkit-background-clip: padding-box;
    // -moz-background-clip: padding;
    backgroundClip.`padding-box`
  )
  val pure_popover_bottom: Cls = cls(
    pure_arrow_border(
      borderColor:="#bfc0c8 transparent transparent transparent",
      bottom:="-20px",
      left:="50%"
    ),
    pure_arrow(
      borderColor:="#f0f1f3 transparent transparent transparent",
      bottom:="-19px",
      left:="50%"
    )
  )
  val pure_popover_top: Cls = cls(
    pure_arrow_border(
      borderColor:="transparent transparent #bfc0c8 transparent",
      top:="-21px",
      left:="50%"
    ),
    pure_arrow(
      borderColor:="transparent transparent #f0f1f3 transparent",
      top:="-20px",
      left:="50%"
    )
  )
  val pure_popover_right: Cls = cls(
    pure_arrow_border(
      borderColor:="transparent transparent transparent #bfc0c8",
      top:="45%",
      right:="-21px"
    ),
    pure_arrow(
      borderColor:="transparent transparent transparent #f0f1f3",
      top:="45%",
      right:="-20px"
    )
  )
  val pure_popover_left: Cls = cls(
    pure_arrow_border(
      borderColor:="transparent #bfc0c8 transparent transparent",
      top:="45%",
      left:="-21px"
    ),
    pure_arrow(
      borderColor:="transparent #f0f1f3 transparent transparent",
      top:="45%",
      left:="-20px"
    )
  )

  /* BUTTON IMPROVEMENTS */
  val pure_button_block: Cls = cls(display.block)
  val pure_button_small: Cls = cls(padding:=".6em 2em .65em", fontSize:="70%")
  val pure_button_large: Cls = cls(padding:=".8em 5em .9em", fontSize:="110%")
  val pure_button_selected: Cls = cls(backgroundColor:="#345fcb", color:="#fff")
  val pure_button_secondary: Cls =
    cls(background:="rgb(161, 195, 238)", color:="rgb(26, 88, 122)")
  val pure_button_error: Cls = cls(background:="rgb(214, 86, 75)", color.white)
  val pure_button_success: Cls =
    cls(background:="rgb(54, 197, 71)", color.white)
  val pure_button_warning: Cls =
    cls(background:="rgb(255, 163, 0)", color.white)

}

object Extras extends Extras