/*
 * Copyright 2017-2018 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

import scala.language.{implicitConversions, postfixOps}

trait PureForm[B, O <: F, F] extends PureCssComponent[B, O, F] {

  import bundle.all._

  val pure_form: C = pc("pure-form")
  val pure_form_stacked: C = pc("pure-form-stacked")
  val pure_form_aligned: C = pc("pure-form-aligned")
  val pure_group: C = pc("pure-group")
  val pure_controls: C = pc("pure-controls")
  val pure_control_group: C = pc("pure-control-group")
  val pure_form_message: C = pc("pure-form-message")
  val pure_form_message_inline: C = pc("pure-form-message-inline")

  implicit def f2cls(f: Form): C = f.toCls
  implicit def f2mod(f: Form): Modifier = f.toCls.apply()

  case class Form(opt: Option[C] = None) extends PureCssElement {
    def stacked: Form = copy(opt = Some(pure_form_stacked))
    def aligned: Form = copy(opt = Some(pure_form_aligned))
    override def toCls: C = pure_form.copy(chain = opt toList)
  }
}
