/*
 * Copyright 2017 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

import scala.language.implicitConversions
import scalatags.generic.Bundle

class PureCssGeneric[Builder, Output <: FragT, FragT](
  bun: Bundle[Builder, Output, FragT]) extends
  PureGrid[Builder, Output, FragT] with
  PureInputs[Builder, Output, FragT] with
  PureButtons[Builder, Output, FragT] with
  PureTable[Builder, Output, FragT] with
  PureForm[Builder, Output, FragT] with
  PureAlerts[Builder, Output, FragT] {

  implicit val bundle: Bundle[Builder, Output, FragT] = bun

  object pure extends PureGrid with PureInput {
    val button = Button()
    val table = Table()
    val img: C = pc("pure-img")
    val form = Form()
  }

  // generic
  val pull_right: C = pc("pull-right")

  // menus
  val pure_menu: C = pc("pure-menu")
  val pure_menu_heading: C = pc("pure-menu-heading")
  val pure_menu_list: C = pc("pure-menu-list")
  val pure_menu_item: C = pc("pure-menu-item")
  val pure_menu_horizontal: C = pc("pure-menu-horizontal")
  val pure_menu_link: C = pc("pure-menu-link")
  val pure_menu_selected: C = pc("pure-menu-selected")
  val pure_menu_disabled: C = pc("pure-menu-disabled")
  val pure_menu_allow_hover: C = pc("pure-menu-allow-hover")
  val pure_menu_has_children: C = pc("pure-menu-has-children")
  val pure_menu_scrollable: C = pc("pure-menu-scrollable")

}
