/*
 * Copyright 2017-2018 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

trait PureGrid[B, O <: F, F] extends PureCssComponent[B, O, F] {

  trait PureGrid {

    // grid
    val g: C = pc("pure-g")
    val u_1: C = pc("pure-u-1")

    // 5ths-based
    val u_1_5: C = pc("pure-u-1-5")
    val u_2_5: C = pc("pure-u-2-5")
    val u_3_5: C = pc("pure-u-3-5")
    val u_4_5: C = pc("pure-u-4-5")

    // 24ths-based
    val u_1_24: C = pc("pure-u-1-24")
    val u_1_12: C = pc("pure-u-1-12")
    val u_2_24: C = pc("pure-u-2-24")
    val u_3_24: C = pc("pure-u-3-24")
    val u_1_8: C = pc("pure-u-1-8")
    val u_4_24: C = pc("pure-u-4-24")
    val u_1_6: C = pc("pure-u-1-6")
    val u_5_24: C = pc("pure-u-5-24")
    val u_1_4: C = pc("pure-u-1-4")
    val u_6_24: C = pc("pure-u-6-24")
    val u_7_24: C = pc("pure-u-7-24")
    val u_1_3: C = pc("pure-u-1-3")
    val u_8_24: C = pc("pure-u-8-24")
    val u_3_8: C = pc("pure-u-3-8")
    val u_9_24: C = pc("pure-u-9-24")
    val u_5_12: C = pc("pure-u-5-12")
    val u_10_24: C = pc("pure-u-10-24")
    val u_11_24: C = pc("pure-u-11-24")
    val u_1_2: C = pc("pure-u-1-2")
    val u_13_24: C = pc("pure-u-13-24")
    val u_7_12: C = pc("pure-u-7-12")
    val u_14_24: C = pc("pure-u-14-24")
    val u_5_8: C = pc("pure-u-5-8")
    val u_15_24: C = pc("pure-u-15-24")
    val u_2_3: C = pc("pure-u-2-3")
    val u_16_24: C = pc("pure-u-16-24")
    val u_17_24: C = pc("pure-u-17-24")
    val u_3_4: C = pc("pure-u-3-4")
    val u_18_24: C = pc("pure-u-18-24")
    val u_19_24: C = pc("pure-u-19-24")
    val u_5_6: C = pc("pure-u-5-6")
    val u_20_24: C = pc("pure-u-20-24")
    val u_7_8: C = pc("pure-u-7-8")
    val u_21_24: C = pc("pure-u-21-24")
    val u_11_12: C = pc("pure-u-11-12")
    val u_22_24: C = pc("pure-u-22-24")
    val u_23_24: C = pc("pure-u-23-24")

  }
}
