/*
 * Copyright 2017-2018 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

import scala.language.implicitConversions
import scalatags.generic.Bundle

trait PureCssComponent[Builder, Output <: FragT, FragT] {
  implicit val bundle: Bundle[Builder, Output, FragT]

  type C = PureCls[Builder, Output, FragT]

  import bundle.all._

  implicit def cls2mod(v: C): Modifier = v()

  protected def pc(c: String): C = PureCls(c)

  trait PureCssElement {
    def toCls: C
    def & (next: C): C = toCls & next
    def & (next: String): C = toCls & next
  }
}
