/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import requestor4s.Session.Params
import Pickler._

trait Session[F[_]] {

  def get[T](path: String, params: Params = Map())(
    implicit rdr: Reader[T]): F[T]

  def post[In, Out](path: String, params: Params = Map(), data: In)(
    implicit wr: Writer[In], rdr: Reader[Out]): F[Out]

  def postUnit[In](path: String, params: Params = Map(), data: In)(
    implicit wr: Writer[In]): F[Unit]

}

object Session {
  type Params = Map[String, String]
}