/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

case class UpdateRequestorUserPost(
  /** (Key) User Id */
  UserProviderKey: String,
  /** User's email. Recommended so the user can receive email notifications. */
  Email: Option[String] = None,
  /** Set true if the user has the EndUser role */
  RoleEndUser: Boolean = false,
  /** Set true if the user has the SmartUser role */
  RoleSmartUser: Boolean = false,
  /** Set true if the user has the Operator role */
  RoleOperator: Boolean = false,
  /** Set true if the user has the SuperOperator role */
  RoleSuperOperator: Boolean = false,
  /** Set true if the user has the Administrator role */
  RoleAdministrator: Boolean = false,
  /** (Optional) Default Customer ID */
  CustomerId: Option[Int] = None,
  /** (Optional) All Customer IDs */
  CustomerIds: Seq[Int] = Seq(),
  /** Internal Group IDs */
  InternalGroupIds: Seq[Int] = Seq(),
  /** Operator Group IDs */
  OperatorGroupIds: Seq[Int] = Seq(),
  /** (Optional) Language. If not set, the default RQ language is used. */
  Language: Option[LanguageEnum] = None,
  /** Firstname */
  FirstName: Option[String] = None,
  /** Lastname */
  LastName: Option[String] = None,
  /** Middlename */
  MiddleName: Option[String] = None,
  /** DisplayName */
  DisplayName: Option[String] = None,
  /** Phones */
  Phones: Seq[String] = Seq(),
  /** SkypeName */
  SkypeName: Option[String] = None,
  /** The time zone identifier (TimeZoneInfo.Id Property). */
  TimeZoneId: Option[String] = None,
  /** Note about the user, for administrators only. */
  AdminNote: Option[String] = None,
  /** Note about the user, for operators only. */
  OperatorNote: Option[String] = None,
  /** AdditionalInformation for users. */
  AdditionalInformation: Option[String] = None,
  /** The Custom Fields data. */
  CustomFields: Seq[CustomFieldData] = Seq())

object UpdateRequestorUserPost {
  implicit val rw: ReadWriter[UpdateRequestorUserPost] = macroRW
}