/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

case class CustomFieldData(
  CustomFieldId: Int,
  DateValue: Option[String] = None,
  DoubleValue: Option[Double] = None,
  LongValue: Option[Int] = None,
  TextBoxValue: Option[String] = None,
  CheckBoxValue: Option[Boolean] = None,
  FieldItem: Option[CustomFieldItemData] = None
)

object CustomFieldData {
  implicit val rw: ReadWriter[CustomFieldData] = macroRW
}

case class CustomFieldItemData(Id: Int, Title: String)

object CustomFieldItemData {
  implicit val rw: ReadWriter[CustomFieldItemData] = macroRW
}
