/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

case class GetCustomersResult(PagedCustomers: PagedCustomers)

object GetCustomersResult {
  implicit val rw: ReadWriter[GetCustomersResult] = macroRW
}

case class PagedCustomers(
  PageIndex: Int,
  PageSize: Int,
  TotalItems: Int,
  TotalPages: Int,
  Items: Seq[CustomerRow] = Seq())

object PagedCustomers {
  implicit val rw: ReadWriter[PagedCustomers] = macroRW
}

case class CustomerRow(
  Id: Int,
  Name: String,
  Location: Option[String] = None,
  Disabled: Boolean = false,
  FieldData: Seq[CustomFieldData] = Seq(),
  LastUpdatedUtc: Option[String] = None,
  CustomerGroups: Seq[CustomerGroupData] = Seq(),
  Tags: Seq[TagData] = Seq()
)

object CustomerRow {
  implicit val rw: ReadWriter[CustomerRow] = macroRW
}