/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

/*
.../Help/ResourceModel?modelName=RequestorApiDataStructures.DataStructures.RequestorUser
 */
case class RequestorUser(
  /** User Id */
  UserProviderKey: String,
  /** Username (login) */
  UserName: Option[String] = None,
  /** E-mail address */
  Email: Option[String] = None,
  /** Firstname */
  FirstName: Option[String] = None,
  /** Lastname */
  LastName: Option[String] = None,
  /** Middlename */
  MiddleName: Option[String] = None,
  /** The name the user wants to display (like nick name) */
  DisplayName: Option[String] = None,
  /** The note beside name, e.g. job position */
  NoteBesideName: Option[String] = None,
  /** Fullname, automatically composed, not null */
  FullName: Option[String] = None,
  /** If true, the user can log on */
  IsApproved: Boolean,
  /** Has End-User role */
  IsEndUser: Boolean,
  /** Has Smart user role */
  IsSmartUser: Boolean,
  /** Has Operator role */
  IsOperator: Boolean,
  /** Has Superoperator role */
  IsSuperOperator: Boolean,
  /** Has Administrator role */
  IsAdministrator: Boolean,
  /** The time zone identifier (TimeZoneInfo.Id Property) */
  TimeZoneId: Option[String] = None,
  /** If true, the account is external */
  ExternalAccount: Boolean,
  /** If true, the account has been created based on a ticket from email */
  EmailAccount: Boolean,
  /** Default customer name (if the user is a member of any) */
  Customer: Option[String] = None,
  /** Default customer Id (if the user is a member of any) */
  CustomerId: Option[Int] = None,
  /** List of all customers (if the user is a member of any) */
  Customers: Seq[UserCustomerData] = Seq(),
  /** Phones */
  Phones: Seq[String] = Seq(),
  /** Information for administrators */
  AdminNote: Option[String] = None,
  /** Information for operators */
  OperatorNote: Option[String] = None,
  /** Additional information about user */
  AdditionalInformation: Option[String] = None,
  /** Skype name */
  SkypeName: Option[String] = None,
  /** List of Ids of operators' groups */
  OperatorGroupIds: Seq[Int] = Seq(),
  /** List of Ids of internals' groups */
  InternalGroupIds: Seq[Int] = Seq(),
  /** User's color. The value will be null if the user does not exist. */
  Color: Option[String] = None,
  /** User's initials. The value will be null if the user does not exist. */
  Initials: Option[String] = None,
  /** Date when photo was changed. If the value is null the photo does not exist. */
  PhotoLastUpdatedUtc: Option[String] = None,
  /** Custom field data. */
  FieldData : Seq[CustomFieldData] = Seq(),
  /** Last update time of the User entity. If not set, the update time is unknown. */
  LastUpdatedUtc : Option[String] = None,
  /** User's language. The language that user used last time in Requestor. */
  Language: Option[LanguageEnum] = None,
  /** If true, the user has been anonymized */
  Anonymized: Boolean,
  /** All customer's tags. */
  Tags: Seq[TagData] = Seq()
)

object RequestorUser {
  implicit val rw: ReadWriter[RequestorUser] = macroRW
}