/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

case class UsersFilterPost(
  /** The requested page index */
  PageIndex: Option[Int] = None,
  /** The requested page size */
  PageSize: Option[Int] = None,
  /** Filter by UserName = None, if set */
  UserName: Option[String] = None,
  /** Filter by Email = None, if set */
  Email: Option[String] = None,
  /** Filter by IsEndUser = None, if set */
  IsEndUser: Option[Boolean] = None,
  /** Filter by IsSmartUser = None, if set */
  IsSmartUser: Option[Boolean] = None,
  /** Filter by IsOperator = None, if set */
  IsOperator: Option[Boolean] = None,
  /** Filter by IsSuperOperator = None, if set */
  IsSuperOperator: Option[Boolean] = None,
  /** Filter by IsAdministrator = None, if set */
  IsAdministrator: Option[Boolean] = None,
  /** Filter by the date of the last user update - from. */
  LastUpdatedDateFromUtc: Option[String] = None,
  /** Filter by the date of the last user update - until. */
  LastUpdatedDateUntilUtc: Option[String] = None)

object UsersFilterPost {
  implicit val rw: ReadWriter[UsersFilterPost] = macroRW
}