/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

case class CreateRequestorUserPost(
   /** Username, login. It cannot be changed later */
  UserName: String,
  /** User's email. Recommended so the user can receive email notifications */
  Email: Option[String] = None,
  /** Password has to meet password policy (minimum length, non alphabetical characters) */
  Password: String,
  /** Set true if the user has the EndUser role */
  RoleEndUser: Boolean = false,
  /** Set true if the user has the SmartUser role */
  RoleSmartUser: Boolean = false,
  /** Set true if the user has the Operator role */
  RoleOperator: Boolean = false,
  /** Set true if the user has the SuperOperator role */
  RoleSuperOperator: Boolean = false,
  /** Set true if the user has the Administrator role */
  RoleAdministrator: Boolean = false,
  /** (Optional) Default Customer ID */
  CustomerId: Option[Int] = None,
  /** (Optional) All Customer IDs */
  CustomerIds: Seq[Int] = Seq(),
  /** (Optional) Internal Group IDs */
  InternalGroupIds: Seq[Int] = Seq(),
  /** (Optional) Operator Group IDs */
  OperatorGroupIds: Seq[Int] = Seq(),
  /** (Optional) Language. If not set, the default RQ language is used. */
  Language: Option[LanguageEnum] = None,
  /** (Optional) Firstname */
  FirstName: Option[String] = None,
  /** (Optional) Lastname */
  LastName: Option[String] = None,
  /** (Optional) Middlename */
  MiddleName: Option[String] = None,
  /** (Optional) The name the user wants to display (like nick name). */
  DisplayName: Option[String] = None,
  /** (Optional) Phone */
  Phone: Option[String] = None,
  /** (Optional) The time zone identifier (TimeZoneInfo.Id Property). If not set, the default RQ TimeZone is used. */
  TimeZoneId: Option[String] = None,
  /** Set true if the user must change his password after the first logging. */
  ChangePasswordAfterLogging: Option[Boolean] = None,
  /** (Optional) Note about the user, for administrators only. */
  AdminNote: Option[String] = None,
  /** (Optional) Additional information about the user. */
  AdditionalInformation: Option[String] = None,
  /** The Custom Fields data. */
  CustomFields: Seq[CustomFieldData] = Seq(),
  /** (Optional) Phones */
  Phones: Seq[String] = Seq())

object CreateRequestorUserPost {
  implicit val rw: ReadWriter[CreateRequestorUserPost] = macroRW
}