/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

case class TagData(
  Id: Int,
  Name: String,
  Static: Boolean,
  Color: Option[String] = None,
  Type: TagType.TagTypeEnum
)

object TagData {
  implicit val rw: ReadWriter[TagData] = macroRW
}

object TagType {

  sealed abstract class TagTypeEnum(val id: Int)

  case object Ticket extends TagTypeEnum(1)
  case object UserAndCompany extends TagTypeEnum(2)
  case class Unknown(override val id: Int) extends TagTypeEnum(id)

  object TagTypeEnum {

    def apply(id: Int): TagTypeEnum = id match {
      case v if v == Ticket.id => Ticket
      case v if v == UserAndCompany.id => UserAndCompany
      case v => Unknown(v)
    }

    implicit val rw: ReadWriter[TagTypeEnum] =
      readwriter[Int].bimap(_.id, apply)
  }
}