/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

case class Customer(
  Id: Int,
  Name: String,
  Phones: Seq[String] = Seq(),
  Emails: Seq[String] = Seq(),
  Web: Option[String] = None,
  Description: Option[String] = None,
  Location: Option[String] = None,
  StreetNo: Option[String] = None,
  PostalCode: Option[String] = None,
  CountryCode: Option[String] = None,
  EmailDomains: Seq[String] = Seq(),
  Disabled: Boolean = false,
  City: Option[String] = None,
  TimeZoneId: Option[String] = None,
  IdentificationNumber: Option[String] = None,
  TaxIdentificationNumber: Option[String] = None,
  FieldData: Seq[CustomFieldData] = Seq(), // Get customer
  CustomFields: Seq[CustomFieldData] = Seq(), // Insert/update customer
  CustomerGroups: Seq[CustomerGroupData] = Seq(),
  Tags: Seq[TagData] = Seq()
)

object Customer {
  implicit val rw: ReadWriter[Customer] = macroRW
}

case class CustomerGroupData(
  Id: Int,
  Name: String,
  Color: Option[String] = None,
  Description: Option[String] = None)

object CustomerGroupData {
  implicit val rw: ReadWriter[CustomerGroupData] = macroRW
}