/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import Pickler._

/*
.../Help/ResourceModel?modelName=Requestor.Domain.Model.Enumerations.LanguageEnum
 */
sealed abstract class LanguageEnum(val id: Int)

object LanguageEnum {

  case object en extends LanguageEnum(0)
  case object de extends LanguageEnum(1)
  case object cs extends LanguageEnum(2)
  case object sk extends LanguageEnum(3)
  case class Other(_id: Int) extends LanguageEnum(_id)

  def apply(id: Int): LanguageEnum =
    Seq(en, de, cs, sk) find(_.id == id) getOrElse Other(id)

  implicit val rw: ReadWriter[LanguageEnum] =
    readwriter[Int].bimap(_.id, apply)

}
