/*
 * Copyright 2021 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package requestor4s

import requestor4s.RequestorApi.Id
import requestor4s.Session.Params
import Pickler._

case class RequestorApi(session: requests.Session, baseUrl: String)
  extends Session[Id] with CustomerApi[Id] with AccountApi[Id] with TagApi[Id] {

  override def get[T](path: String, params: Params)(
    implicit rdr: Reader[T]): Id[T] =
    Id[T](Pickler.read[T](session.get(s"$baseUrl/$path", params = params)
      .text()))

  override def post[In, Out](path: String, params: Params, data: In)(
    implicit wr: Pickler.Writer[In], rdr: Pickler.Reader[Out]): Id[Out] =
    Id[Out](Pickler.read[Out](session.post(s"$baseUrl/$path", params = params,
      data = Pickler.writeJs(data))))

  override def postUnit[In](path: String, params: Params, data: In)(
    implicit wr: Pickler.Writer[In]): Id[Unit] = {
    session.post(s"$baseUrl/$path", params = params,
      data = Pickler.writeJs(data))
    Id[Unit](null)
  }
}


object RequestorApi {
  case class Id[T](v: T)
}