/*
 * Copyright 2019 Tomas Zeman <tomas@functionals.cz>, <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cz.functionals.visjs

import scala.scalajs.js
import scala.scalajs.js.UndefOr

class GraphEdge(val from: String,
  val to: String,
  val label: UndefOr[String] = js.undefined,
  val arrows: UndefOr[String] = js.undefined,
  val title: UndefOr[String] = js.undefined
) extends js.Object

object GraphEdge {
  sealed abstract class Arrow(val v: String)
  case object From extends Arrow("from")
  case object To extends Arrow("to")
  case object Middle extends Arrow("middle")
  object Arrows {
    def apply(xs: Arrow*): String = xs.toSet mkString ","
  }
}
