/*
 * Copyright 2019 Tomas Zeman <tomas@functionals.cz>, <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cz.functionals.visjs

import scala.scalajs.js

class Interaction(
  val dragNodes: Boolean = true,
  val dragView: Boolean = true,
  val hideEdgesOnDrag: Boolean = false,
  //(Unknown option detected) val hideEdgesOnZoom: Boolean = false,
  val hideNodesOnDrag: Boolean = false,
  val hover: Boolean = false,
  val hoverConnectedEdges: Boolean = true,
  val multiselect: Boolean = false,
  val navigationButtons: Boolean = false,
  val selectable: Boolean = true,
  val selectConnectedEdges: Boolean = true,
  val tooltipDelay: Int = 300,
  val zoomView: Boolean = true
) extends js.Object

/*
https://visjs.github.io/vis-network/docs/network/interaction.html#
interaction:{
    dragNodes:true,
    dragView: true,
    hideEdgesOnDrag: false,
    hideEdgesOnZoom: false,
    hideNodesOnDrag: false,
    hover: false,
    hoverConnectedEdges: true,
    keyboard: {
      enabled: false,
      speed: {x: 10, y: 10, zoom: 0.02},
      bindToWindow: true
    },
    multiselect: false,
    navigationButtons: false,
    selectable: true,
    selectConnectedEdges: true,
    tooltipDelay: 300,
    zoomView: true
  }
 */
