/*
 * Copyright 2019-2020 Tomas Zeman <tomas@functionals.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cz.functionals.visjs

import cz.functionals.visjs.GraphNode.{Fixed, Font}
import org.scalajs.dom

import scala.scalajs.js
import scala.scalajs.js.{UndefOr, |}

// https://visjs.github.io/vis-network/docs/network/nodes.html

class GraphNode(
  val id: String,
  val label: String,
  var title: UndefOr[String|dom.Element] = js.undefined,
  var color: UndefOr[String] = js.undefined,
  var image: UndefOr[js.Any] = js.undefined,
  var shape: UndefOr[String] = js.undefined,
  var widthConstraint: Boolean | Int | GraphNodeMinMax = false,
  var fixed: Boolean | Fixed = false,
  var font: String | Font = new Font()
) extends js.Object

class GraphNodeMinMax(
  val minimum: UndefOr[Int] = js.undefined,
  val maximum: UndefOr[Int] = js.undefined) extends js.Object

object GraphNode {
  class Font(
    val color: String = "#343434",
    val size: Int = 14,
    val face: String = "arial",
    val background: UndefOr[String] = js.undefined,
    val strokeWidth: Int = 0,
    val strokeColor: String = "#ffffff",
    val align: String = "center",
    val vadjust: Int = 0,
    val multi: Boolean | String = false,
    val bold: Boolean | js.Object = false,
    val ital: Boolean | js.Object = false,
    val boldital: Boolean | js.Object = false,
    val mono: Boolean | js.Object = false
  ) extends js.Object

  class Fixed(val x: Boolean = false, val y: Boolean = false) extends js.Object
}
