/*
 * Copyright 2019 Tomas Zeman <tomas@functionals.cz>, <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cz.functionals.visjs

import org.scalajs.dom.Node

import scala.scalajs.js
import scala.scalajs.js.JSConverters._
import scala.scalajs.js.annotation.JSGlobal

@js.native
@JSGlobal("vis.Network")
class Network(container: Node, data: NetworkData, options: NetworkOptions)
  extends js.Object {
  def destroy(): Unit = js.native
  //def on(eventName: String, callback: js.Function1[js.Any, Unit]): Unit = js.native
  def on[Ev](eventName: String, callback: js.Function1[Ev, Unit]): Unit = js.native
  def setData(data: NetworkData): Unit = js.native
}

class NetworkOptions(
  val physics: js.Object = new js.Object(), // must be defined
  val interaction: Interaction = new Interaction()
) extends js.Object

/*
https://visjs.org/docs/network/#options
var options = {
  autoResize: true,
  height: '100%',
  width: '100%'
  locale: 'en',
  locales: locales,
  clickToUse: false,
  configure: {...},    // defined in the configure module.
  edges: {...},        // defined in the edges module.
  nodes: {...},        // defined in the nodes module.
  groups: {...},       // defined in the groups module.
  layout: {...},       // defined in the layout module.
  interaction: {...},  // defined in the interaction module.
  manipulation: {...}, // defined in the manipulation module.
  physics: {...},      // defined in the physics module.
}
 */

trait NetworkData extends js.Object

object NetworkData {
  def apply(nodes: Seq[GraphNode], edges: Seq[GraphEdge]): NetworkData =
    apply(new DataSet(nodes.toJSArray), new DataSet(edges.toJSArray))

  def apply(nodes: DataSet[GraphNode], edges: DataSet[GraphEdge]): NetworkData =
    js.Dynamic.literal(nodes = nodes, edges = edges).asInstanceOf[NetworkData]
}
