/*
 * Copyright 2019 Tomas Zeman <tomas@functionals.cz>, <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cz.functionals.visjs

import scala.scalajs.js
import scala.scalajs.js.UndefOr

class HoverNodeEvent(val node: String) extends js.Object

class ClickEvent(
  val nodes: js.Array[String],
  val edges: js.Array[String],
  val items: UndefOr[js.Array[ClickItem]]) extends js.Object

class ClickItem(
  val nodeId: UndefOr[String],
  val edgeId: UndefOr[String],
  val labelId: UndefOr[String]) extends js.Object
