/*
 * Copyright 2017-2018 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

import scala.language.implicitConversions

trait PureAlerts[B, O <: F, F] extends PureCssComponent[B, O, F] {
  import bundle.all._

  val pure_alert: C = pc("pure-alert")
  val pure_alert_error: C = pc("pure-alert-error")
  val pure_alert_warning: C = pc("pure-alert-warning")
  val pure_alert_success: C = pc("pure-alert-success")

  implicit def alert2cls(a: Alert): C = a.toCls
  implicit def alert2mod(a: Alert): Modifier = a.toCls.apply()

  sealed abstract class Alert(val secondary: C) {
    def toCls: C = pure_alert & secondary
  }

  object Alert {
    case object Error extends Alert(pure_alert_error)
    case object Warning extends Alert(pure_alert_warning)
    case object Success extends Alert(pure_alert_success)
  }
}
