/*
 * Copyright 2017-2018 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

import scala.language.{implicitConversions, postfixOps}

trait PureButtons[B, O <: F, F] extends PureCssComponent[B, O ,F] {
  import bundle.all._

  val pure_button: C = pc("pure-button")
  val pure_button_disabled: C = pc("pure-button-disabled")
  val pure_button_active: C = pc("pure-button-active")
  val pure_button_primary: C = pc("pure-button-primary")
  val pure_button_secondary: C = pc("pure-button-secondary")
  val pure_button_success: C = pc("pure-button-success")
  val pure_button_error: C = pc("pure-button-error")
  val pure_button_warning: C = pc("pure-button-warning")
  val pure_button_small: C = pc("pure-button-small")
  val pure_button_large: C = pc("pure-button-large")
  val pure_button_group: C = pc("pure-button-group")

  implicit def btn2cls(b: Button): C = b.toCls
  implicit def btn2mod(b: Button): Modifier = b.toCls.apply()

  case class Button(role: Option[C] = None, state: Option[C] = None,
    level: Option[C] = None, size: Option[C] = None) extends PureCssElement {
    type B = Button

    def primary: B = copy(role = Some(pure_button_primary))
    def secondary: B = copy(role = Some(pure_button_secondary))

    def active: B = copy(state = Some(pure_button_active))
    def disabled: B = copy(state = Some(pure_button_disabled))

    def success: B = copy(level = Some(pure_button_success))
    def warning: B = copy(level = Some(pure_button_warning))
    def error: B = copy(level = Some(pure_button_error))

    def small: B = copy(size = Some(pure_button_small))
    def large: B = copy(size = Some(pure_button_large))

    def toCls: C =
      pure_button.copy(chain = (role ++ state ++ level ++ size) toList)

  }

}
