/*
 * Copyright 2017-2018 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

import scalatags.generic.{Bundle, Modifier}

case class PureCls[Builder, Output <: FragT, FragT](
  css: String,
  chain: List[PureCls[Builder, Output, FragT]] = Nil
) {

  type Self = PureCls[Builder, Output, FragT]

  def & (next: Self): Self = copy(chain = next :: chain)
  def & (next: String): Self = this & PureCls[Builder, Output, FragT](next)

  def apply()(implicit bundle: Bundle[Builder, Output, FragT]):
  Modifier[Builder] = {
    import bundle.all._
    cls:=asCss
  }

  def asCss: String = (this :: chain.reverse) map(_.css) mkString " "
}


