/*
 * Copyright 2017-2018 Tomas Zeman <tzeman@volny.cz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package purecss.generic

import scala.language.{implicitConversions, postfixOps}

trait PureTable[B, O <: F, F] extends PureCssComponent[B, O, F] {

  import bundle.all._

  val pure_table: C = pc("pure-table")
  val pure_table_bordered: C = pc("pure-table-bordered")
  val pure_table_horizontal: C = pc("pure-table-horizontal")
  val pure_table_striped: C = pc("pure-table-striped")

  implicit def tbl2cls(t: Table): C = t.toCls
  implicit def tbl2mod(t: Table): Modifier = t.toCls.apply()

  case class Table(opt: Option[C] = None) extends PureCssElement {
    def bordered: Table = copy(opt = Some(pure_table_bordered))
    def horizontal: Table = copy(opt = Some(pure_table_horizontal))
    def striped: Table = copy(opt = Some(pure_table_striped))

    def toCls: C = pure_table.copy(chain = opt toList)
  }
}
