package net.tz

import com.bedatadriven.spss.{SpssVariable => JVar}

import scala.collection.JavaConverters._
import scala.language.{implicitConversions, postfixOps}

package object spss {

  type DoubleRange = (Double, Double)

  implicit def spssVarJtoS(v: JVar): SpssVariable = SpssVariable(
    name = v.getVariableName,
    shortName = v.getShortName,
    isNumeric = v.isNumeric,
    index = v.getIndex,
    label = v.getVariableLabel,
    missingRange = if (v.isHasMissingRange)
      Some((v.getMissingMin.doubleValue(), v.getMissingMax.doubleValue()))
    else None,
    missing = v.getMissing.asScala.map(_.doubleValue()).toList,
    missingStrings = v.getMissingStrings.asScala.toList,
    labels = v.getValueLabels.asScala.map { case (k,x) =>
      (k.doubleValue(), x) } toMap)
}
