package net.tz.spss

import java.io.File

import com.bedatadriven.spss.SpssDataFileReader

import scala.collection.JavaConverters._
import scala.language.postfixOps

class SpssReader(private val r: SpssDataFileReader)
  extends Iterator[Map[SpssVariable, SpssValue]] {

  lazy val variables: List[SpssVariable] =
    r.getVariables.asScala.toList map spssVarJtoS

  override def hasNext: Boolean = r.readNextCase()

  override def next(): Map[SpssVariable, SpssValue] =
    variables map(v => (v, asValue(v))) toMap

  private def asValue(variable: SpssVariable): SpssValue = {
    val i = variable.index
    if (r.isSystemMissing(i)) {
      SystemMissing
    } else if (variable.isNumeric) {
      Option(r.getDoubleValue(i)) map(x =>
        if (r.isValueMissing(i, x)) MissingDouble(x) else DoubleValue(x)
        ) getOrElse SystemMissing
    } else {
      Option(r.getStringValue(i)) map StringValue getOrElse SystemMissing
    }
  }
}

object SpssReader {
  def apply(f: File): SpssReader = new SpssReader(new SpssDataFileReader(f))
}