package net.tz.spss

sealed trait SpssValue

sealed trait Missing extends SpssValue

abstract class Value[T] extends SpssValue {
  def v: T
}

abstract class MissingValue[T] extends Value[T]

case class StringValue(v: String) extends Value[String]
case class DoubleValue(v: Double) extends Value[Double]
case object SystemMissing extends Missing
// ??? case class MissingString(v: String) extends MissingValue[String]
case class MissingDouble(v: Double) extends MissingValue[Double]
